/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Callback;
import com.sun.jna.CallbackReference;
import com.sun.jna.FromNativeConverter;
import com.sun.jna.FunctionParameterContext;
import com.sun.jna.FunctionResultContext;
import com.sun.jna.FunctionResultContext$CallbackResultContext;
import com.sun.jna.Memory;
import com.sun.jna.MethodParameterContext;
import com.sun.jna.MethodResultContext;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.NativeMapped;
import com.sun.jna.NativeMappedConverter;
import com.sun.jna.NativeString;
import com.sun.jna.Pointer;
import com.sun.jna.StringArray;
import com.sun.jna.Structure;
import com.sun.jna.StructureWriteContext$MethodResultContext;
import com.sun.jna.ToNativeConverter;
import com.sun.jna.TypeMapper;
import com.sun.jna.Union$CallbackResultContext;
import com.sun.jna.Union$PointerType;
import com.sun.jna.VarArgsChecker;
import com.sun.jna.WString;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import melotr.ConfigChangedHandler;
import melotr.MCDARichHelper;

public class Function
extends Pointer {
    public static final int THROW_LAST_ERROR = 64;
    final Map<String, ?> options;
    public static final int USE_VARARGS = 384;
    private static final VarArgsChecker IS_VARARGS;
    public static final int MAX_NARGS = 256;
    private NativeLibrary library;
    private final String functionName;
    final int callFlags;
    static final Integer INTEGER_FALSE;
    private static final int MASK_CC = 63;
    static final String OPTION_INVOKING_METHOD;
    public static final int ALT_CONVENTION = 63;
    final String encoding;
    static final Integer INTEGER_TRUE;
    public static final int C_CONVENTION = 0;

    private /* synthetic */ String invokeString(int callFlags, Object[] args, boolean wide) {
        Pointer ptr = this.invokePointer(callFlags, args);
        String s = null;
        if (ptr != null) {
            s = wide ? ptr.getWideString(0L) : ptr.getString(0L, this.encoding);
        }
        return s;
    }

    static Boolean valueOf(boolean b) {
        return b ? Boolean.TRUE : Boolean.FALSE;
    }

    static Object[] concatenateVarArgs(Object[] inArgs) {
        if (inArgs != null && inArgs.length > 0) {
            Class<?> argType;
            Object lastArg = inArgs[inArgs.length - 1];
            Class<?> clazz = argType = lastArg != null ? lastArg.getClass() : null;
            if (argType != null && argType.isArray()) {
                Object[] varArgs = (Object[])lastArg;
                for (int i = 0; i < varArgs.length; ++i) {
                    if (!(varArgs[i] instanceof Float)) continue;
                    varArgs[i] = (double)((Float)varArgs[i]).floatValue();
                }
                Object[] fullArgs = new Object[inArgs.length + varArgs.length];
                System.arraycopy(inArgs, 0, fullArgs, 0, inArgs.length - 1);
                System.arraycopy(varArgs, 0, fullArgs, inArgs.length - 1, varArgs.length);
                fullArgs[fullArgs.length - 1] = null;
                inArgs = fullArgs;
            }
        }
        return inArgs;
    }

    Object invoke(Object[] args, Class<?> returnType, boolean allowObjects, int fixedArgs) {
        Object result = null;
        int callFlags = this.callFlags | (fixedArgs & 3) << 7;
        if (returnType == null || returnType == Void.TYPE || returnType == Void.class) {
            Native.invokeVoid(this, this.peer, callFlags, args);
            result = null;
        } else if (returnType == Boolean.TYPE || returnType == Boolean.class) {
            result = Function.valueOf(Native.invokeInt(this, this.peer, callFlags, args) != 0);
        } else if (returnType == Byte.TYPE || returnType == Byte.class) {
            result = (byte)Native.invokeInt(this, this.peer, callFlags, args);
        } else if (returnType == Short.TYPE || returnType == Short.class) {
            result = (short)Native.invokeInt(this, this.peer, callFlags, args);
        } else if (returnType == Character.TYPE || returnType == Character.class) {
            result = Character.valueOf((char)Native.invokeInt(this, this.peer, callFlags, args));
        } else if (returnType == Integer.TYPE || returnType == Integer.class) {
            result = Native.invokeInt(this, this.peer, callFlags, args);
        } else if (returnType == Long.TYPE || returnType == Long.class) {
            result = Native.invokeLong(this, this.peer, callFlags, args);
        } else if (returnType == Float.TYPE || returnType == Float.class) {
            result = Float.valueOf(Native.invokeFloat(this, this.peer, callFlags, args));
        } else if (returnType == Double.TYPE || returnType == Double.class) {
            result = Native.invokeDouble(this, this.peer, callFlags, args);
        } else if (returnType == String.class) {
            result = this.invokeString(callFlags, args, false);
        } else if (returnType == WString.class) {
            String s = this.invokeString(callFlags, args, true);
            if (s != null) {
                result = new WString(s);
            }
        } else {
            if (Pointer.class.isAssignableFrom(returnType)) {
                return this.invokePointer(callFlags, args);
            }
            if (Structure.class.isAssignableFrom(returnType)) {
                if (Structure.ByValue.class.isAssignableFrom(returnType)) {
                    Structure s = Native.invokeStructure(this, this.peer, callFlags, args, Structure.newInstance(returnType));
                    s.autoRead();
                    result = s;
                } else {
                    result = this.invokePointer(callFlags, args);
                    if (result != null) {
                        Object s = Structure.newInstance(returnType, (Pointer)result);
                        ((Structure)s).conditionalAutoRead();
                        result = s;
                    }
                }
            } else if (Callback.class.isAssignableFrom(returnType)) {
                result = this.invokePointer(callFlags, args);
                if (result != null) {
                    result = CallbackReference.getCallback(returnType, (Pointer)result);
                }
            } else if (returnType == String[].class) {
                Pointer p = this.invokePointer(callFlags, args);
                if (p != null) {
                    result = p.getStringArray(0L, this.encoding);
                }
            } else if (returnType == WString[].class) {
                Pointer p = this.invokePointer(callFlags, args);
                if (p != null) {
                    String[] arr = p.getWideStringArray(0L);
                    WString[] warr = new WString[arr.length];
                    for (int i = 0; i < arr.length; ++i) {
                        warr[i] = new WString(arr[i]);
                    }
                    result = warr;
                }
            } else if (returnType == Pointer[].class) {
                Pointer p = this.invokePointer(callFlags, args);
                if (p != null) {
                    result = p.getPointerArray(0L);
                }
            } else if (allowObjects) {
                result = Native.invokeObject(this, this.peer, callFlags, args);
                if (result != null && !returnType.isAssignableFrom(result.getClass())) {
                    throw new ClassCastException(MCDARichHelper.l(FunctionResultContext$CallbackResultContext.p("\ub825\u513c\uede3\u25f5\u1be0\uc69d\u3cc6\u7ffe\uc47c\ua26c\ufb59\u125f")) + returnType + ConfigChangedHandler.l(FunctionResultContext$CallbackResultContext.p("\ub84f\u513a\uede0\u25e2\u1bf9\uc6d4\u3c90\u7fe2\uc469\ua23b\ufb49\u1219\u00e2\udd49\u44f6\ue763\ud398\u8231\u825a\u2114\u7d86\ucbc2\u9a8a")) + result.getClass());
                }
            } else {
                throw new IllegalArgumentException(MCDARichHelper.l(FunctionResultContext$CallbackResultContext.p("\ub822\u5137\uede4\u25f5\u1be2\uc683\u3c89\u7ff8\uc471\ua279\ufb58\u125f\u00fc\udd48\u44f2\ue731\ud380\u823d\u8211\u2112\u7d8b\ucbc1\u9ad7\ue026")) + returnType + ConfigChangedHandler.l(FunctionResultContext$CallbackResultContext.p("\ub84f\u5137\uede1\u25a7\u1bec\uc681\u3c90\u7fee\uc469\ua272\ufb4b\u1216\u00b6")) + this.getName());
            }
        }
        return result;
    }

    public Object invoke(Class<?> returnType, Object[] inArgs, Map<String, ?> options) {
        Method invokingMethod = (Method)options.get(StructureWriteContext$MethodResultContext.u("\u4edf\uf86e\u74e4\u5a2b\u2cf4\u058c\u34dd\u2b3f\u963d\u6fa6\u8b66\ue0a8\u7676\ud9d2\u592c"));
        Class<?>[] paramTypes = invokingMethod != null ? invokingMethod.getParameterTypes() : null;
        return this.invoke(invokingMethod, paramTypes, returnType, inArgs, options);
    }

    public static Function getFunction(String libraryName, String functionName, int callFlags, String encoding) {
        return NativeLibrary.getInstance(libraryName).getFunction(functionName, callFlags, encoding);
    }

    private /* synthetic */ Object convertArgument(Object[] args, int index, Method invokingMethod, TypeMapper mapper, boolean allowObjects, Class<?> expectedType) {
        Object arg = args[index];
        if (arg != null) {
            Class<?> type = arg.getClass();
            ToNativeConverter converter = null;
            if (NativeMapped.class.isAssignableFrom(type)) {
                converter = NativeMappedConverter.getInstance(type);
            } else if (mapper != null) {
                converter = mapper.getToNativeConverter(type);
            }
            if (converter != null) {
                FunctionParameterContext context = invokingMethod != null ? new MethodParameterContext(this, args, index, invokingMethod) : new FunctionParameterContext(this, args, index);
                arg = converter.toNative(arg, context);
            }
        }
        if (arg == null || this.isPrimitiveArray(arg.getClass())) {
            return arg;
        }
        Class<?> argClass = arg.getClass();
        if (arg instanceof Structure) {
            Structure struct = (Structure)arg;
            struct.autoWrite();
            if (struct instanceof Structure.ByValue) {
                Class<?> ptype = struct.getClass();
                if (invokingMethod != null) {
                    Class<?>[] ptypes = invokingMethod.getParameterTypes();
                    if (IS_VARARGS.isVarArgs(invokingMethod)) {
                        if (index < ptypes.length - 1) {
                            ptype = ptypes[index];
                        } else {
                            Class<?> etype = ptypes[ptypes.length - 1].getComponentType();
                            if (etype != Object.class) {
                                ptype = etype;
                            }
                        }
                    } else {
                        ptype = ptypes[index];
                    }
                }
                if (Structure.ByValue.class.isAssignableFrom(ptype)) {
                    return struct;
                }
            }
            return struct.getPointer();
        }
        if (arg instanceof Callback) {
            return CallbackReference.getFunctionPointer((Callback)arg);
        }
        if (arg instanceof String) {
            return new NativeString((String)arg, false).getPointer();
        }
        if (arg instanceof WString) {
            return new NativeString(arg.toString(), true).getPointer();
        }
        if (arg instanceof Boolean) {
            return Boolean.TRUE.equals(arg) ? INTEGER_TRUE : INTEGER_FALSE;
        }
        if (String[].class == argClass) {
            return new StringArray((String[])arg, this.encoding);
        }
        if (WString[].class == argClass) {
            return new StringArray((WString[])arg);
        }
        if (Pointer[].class == argClass) {
            return new PointerArray((Pointer[])arg);
        }
        if (NativeMapped[].class.isAssignableFrom(argClass)) {
            return new NativeMappedArray((NativeMapped[])arg);
        }
        if (Structure[].class.isAssignableFrom(argClass)) {
            Structure[] ss = (Structure[])arg;
            Class<?> type = argClass.getComponentType();
            boolean byRef = Structure.ByReference.class.isAssignableFrom(type);
            if (expectedType != null && !Structure.ByReference[].class.isAssignableFrom(expectedType)) {
                if (byRef) {
                    throw new IllegalArgumentException(MCDARichHelper.l(StructureWriteContext$MethodResultContext.u("\u3c78\u8b12\u6420\u80a9\uacc2\u693f\ub2d9\uecdb\u2c42")) + this.getName() + ConfigChangedHandler.l(StructureWriteContext$MethodResultContext.u("\u3c75\u8b77\u6440\u80dd\uacb1\u6943\ub2af\ueca4\u2c6d\u9d53\u6a7a\ua7a9\uef14\u80d8\u5c25\u49db\u3202\u5de3\u3146\u60b3\u110a\ue51a\u0307\ub602\u10f6\u268d\u5ae2\u5248\u213a\ud1a1\ueec6\uc7c4\u9990\udeed\u1f21")) + index + MCDARichHelper.l(StructureWriteContext$MethodResultContext.u("\u3c6d\u8b76\u6448\u80cd\uace5\u6944\ub2b7\uecb4\u2c70\u9d0d\u6a11\ua7b5\uef18\u808a")) + type + ConfigChangedHandler.l(StructureWriteContext$MethodResultContext.u("\u3c75\u8b64\u6444\u80cd\uacfd\u6952\ub2bc\uecb2\u2c7a\u9d16\u6a4d")));
                }
                for (int i = 0; i < ss.length; ++i) {
                    if (!(ss[i] instanceof Structure.ByReference)) continue;
                    throw new IllegalArgumentException(MCDARichHelper.l(StructureWriteContext$MethodResultContext.u("\u3c78\u8b12\u6420\u80a9\uacc2\u693f\ub2d9\uecdb\u2c42")) + this.getName() + ConfigChangedHandler.l(StructureWriteContext$MethodResultContext.u("\u3c75\u8b77\u6440\u80dd\uacb1\u6943\ub2af\ueca4\u2c6d\u9d53\u6a7a\ua7a9\uef14\u80d8\u5c25\u49db\u3202\u5de3\u3146\u60b3\u110a\ue51a\u0307\ub602\u10f6\u268d\u5ae2\u5248\u213a\ud1a1\ueec6\uc7c4\u9990\udeed\u1f21")) + index + MCDARichHelper.l(StructureWriteContext$MethodResultContext.u("\u3c1e\u8b05\u643b\u80be\uac96\u6933\ub2da\uecd0\u2c0f\u9d62\u6a2c\ua7dd\uef2d")) + i + ConfigChangedHandler.l(StructureWriteContext$MethodResultContext.u("\u3c75\u8b7a\u6456\u809e\uacb2\u6944\ub2fd\uec92\u2c7d\u9d01\u6a5c\ua7be\uef12\u80d8\u5c34\u49ca\u3259\u5dd3\u315a\u60ba\u1132\ue55c\u0303\ub604\u10b3\u2693\u5ae0\u525f\u217b\ud1b8\ueeda\uc7c0\u9990")));
                }
            }
            if (byRef) {
                Structure.autoWrite(ss);
                Pointer[] pointers = new Pointer[ss.length + 1];
                for (int i = 0; i < ss.length; ++i) {
                    pointers[i] = ss[i] != null ? ss[i].getPointer() : null;
                }
                return new PointerArray(pointers);
            }
            if (ss.length == 0) {
                throw new IllegalArgumentException(MCDARichHelper.l(StructureWriteContext$MethodResultContext.u("\u3c6d\u8b13\u643c\u80bf\uacd5\u6922\ub2c3\uecc7\u2c07\u9d27\u6a23\ua7db\uef7f\u80b8\u5c54\u49fb\u3271\u5d90\u313b\u60e8\u111c\ue526\u036c\ub674\u10d8\u26a9\u5a86\u5221\u215e\ud195\ueeb2\uc7a1\u99ec\ude84\u1f4a\uc0c9\uc212\u360a\uda06\u1274\u0686")));
            }
            if (ss[0] == null) {
                ((Structure)Structure.newInstance(type)).toArray(ss);
                return ss[0].getPointer();
            }
            Structure.autoWrite(ss);
            return ss[0].getPointer();
        }
        if (argClass.isArray()) {
            throw new IllegalArgumentException(ConfigChangedHandler.l(StructureWriteContext$MethodResultContext.u("\u3c00\u8b7d\u6456\u80cb\uacad\u6952\ub2b2\uecb3\u2c7d\u9d16\u6a4d\ua7fd\uef07\u80df\u5c34\u49ce\u320e\u5db1\u3142\u609a\u1130\ue54f\u030b\ub613\u10b8\u2689\u5aa3\u524e\u2122\ud1bc\ueec6\uc78a\u99d5")) + argClass.getComponentType());
        }
        if (allowObjects) {
            return arg;
        }
        if (!Native.isSupportedNativeType(arg.getClass())) {
            throw new IllegalArgumentException(MCDARichHelper.l(StructureWriteContext$MethodResultContext.u("\u3c18\u8b7a\u644e\u80cc\uacb5\u6955\ub2aa\uecb4\u2c65\u9d11\u6a55\ua7fa\uef1f\u80d8\u5c39\u49dd\u3202\u5df3\u3155\u609b\u116f\ue549\u0307\ub601\u10ab\u26da")) + arg.getClass().getName() + ConfigChangedHandler.l(StructureWriteContext$MethodResultContext.u("\u3c19\u8b1e\u643d\u80f2\uacc1\u692f\ub2c3\ueccc\u2c08\u9d7a\u6a31\ua7d4\uef78\u80e1")) + index + MCDARichHelper.l(StructureWriteContext$MethodResultContext.u("\u3c1e\u8b08\u6428\u80ea\uacd0\u6923\ub2d8\uecd6\u2c16\u9d6e\u6a2d\ua7c7\uef2d")) + this.getName());
        }
        return arg;
    }

    public String invokeString(Object[] args, boolean wide) {
        Object o = this.invoke(wide ? WString.class : String.class, args);
        return o != null ? o.toString() : null;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() == this.getClass()) {
            Function other = (Function)o;
            return other.callFlags == this.callFlags && other.options.equals(this.options) && other.peer == this.peer;
        }
        return false;
    }

    static int fixedArgs(Method m) {
        return IS_VARARGS.fixedArgs(m);
    }

    public long invokeLong(Object[] args) {
        return (Long)this.invoke(Long.class, args);
    }

    Object invoke(Object[] args, Class<?> returnType, boolean allowObjects) {
        return this.invoke(args, returnType, allowObjects, 0);
    }

    public double invokeDouble(Object[] args) {
        return (Double)this.invoke(Double.class, args);
    }

    private /* synthetic */ boolean isPrimitiveArray(Class<?> argClass) {
        return argClass.isArray() && argClass.getComponentType().isPrimitive();
    }

    public int invokeInt(Object[] args) {
        return (Integer)this.invoke(Integer.class, args);
    }

    public Object invoke(Class<?> returnType, Object[] inArgs) {
        return this.invoke(returnType, inArgs, this.options);
    }

    public Pointer invokePointer(Object[] args) {
        return (Pointer)this.invoke(Pointer.class, args);
    }

    public static Function getFunction(String libraryName, String functionName, int callFlags) {
        return NativeLibrary.getInstance(libraryName).getFunction(functionName, callFlags, null);
    }

    static {
        OPTION_INVOKING_METHOD = Union$CallbackResultContext.U("\u6523\ucda5\u8184\u94ef\u449b\u89eb\uf0e0\u1e0e\uac74\uf285\uc55a\uf18f\ua9b0\ub352\ude6d");
        INTEGER_TRUE = -1;
        INTEGER_FALSE = 0;
        IS_VARARGS = VarArgsChecker.create();
    }

    public float invokeFloat(Object[] args) {
        return ((Float)this.invoke(Float.class, args)).floatValue();
    }

    public static Function getFunction(Pointer p, int callFlags, String encoding) {
        return new Function(p, callFlags, encoding);
    }

    Function(Pointer functionAddress, int callFlags, String encoding) {
        this.checkCallingConvention(callFlags & 0x3F);
        if (functionAddress == null || functionAddress.peer == 0L) {
            throw new NullPointerException(ConfigChangedHandler.l(StructureWriteContext$MethodResultContext.u("\u15ec\ueebd\u57c0\uc4d4\udc7c\ua276\udf7b\u9da9\u2d58\ua7ad\u922b\u1695\u99bb\u9613\ue833\u2bdf\ua4f9\ub053\u9009\uffb0\uaec7\udbff\u280c\u4d71\u7002\u993e\u125d\uecc0\u2dd7\u5532\u9ba7\u9419")));
        }
        this.functionName = functionAddress.toString();
        this.callFlags = callFlags;
        this.peer = functionAddress.peer;
        this.options = Collections.EMPTY_MAP;
        this.encoding = encoding != null ? encoding : Native.getDefaultStringEncoding();
    }

    private /* synthetic */ void checkCallingConvention(int convention) throws IllegalArgumentException {
        if ((convention & 0x3F) != convention) {
            throw new IllegalArgumentException(MCDARichHelper.l(FunctionResultContext$CallbackResultContext.p("\u4c4b\uef43\u5217\u8595\u5dd7\ud843\u7d06\u7ebb\ucbcb\u0d50\u6379\u29ab\u83b9\ucc26\u02d2\ubee1\ud81f\u0f8f\u4bf3\u5880\ube96\u4a6b\u87c0\u4fe4\u120f\u882c\u5466\uc87b\uee43\uc0ad\u20c9\u0b18\u803e")) + convention);
        }
    }

    public static Function getFunction(Pointer p, int callFlags) {
        return Function.getFunction(p, callFlags, null);
    }

    public static Function getFunction(Pointer p) {
        return Function.getFunction(p, 0, null);
    }

    private /* synthetic */ Pointer invokePointer(int callFlags, Object[] args) {
        long ptr = Native.invokePointer(this, this.peer, callFlags, args);
        return ptr == 0L ? null : new Pointer(ptr);
    }

    public void invoke(Object[] args) {
        this.invoke(Void.class, args);
    }

    @Override
    public String toString() {
        if (this.library != null) {
            return ConfigChangedHandler.l(Union$PointerType.H("\ubf12\u9f4c\uabb1\u0b08\u53c6\u3999\ufb3a\u5a02\ufa04\u0d6e\u608b\u17c1\u180f\u72c5\u412f\uc108")) + this.functionName + MCDARichHelper.l(Union$PointerType.H("\ubf53")) + this.library.getName() + ConfigChangedHandler.l(Union$PointerType.H("\ubf55\u9f6d\uabf5\u0b19")) + Long.toHexString(this.peer);
        }
        return MCDARichHelper.l(Union$PointerType.H("\ubf66\u9f27\uabc5\u0b63\u53b2\u39f2\ufb4e\u5a69\ufa70\u0d05\u60ff\u17aa\u187b\u72ae\u415b\uc103\u0a90\u5523")) + Long.toHexString(this.peer);
    }

    public String getName() {
        return this.functionName;
    }

    public static Function getFunction(String libraryName, String functionName) {
        return NativeLibrary.getInstance(libraryName).getFunction(functionName);
    }

    static boolean isVarArgs(Method m) {
        return IS_VARARGS.isVarArgs(m);
    }

    public Object invokeObject(Object[] args) {
        return this.invoke(Object.class, args);
    }

    public int getCallingConvention() {
        return this.callFlags & 0x3F;
    }

    public void invokeVoid(Object[] args) {
        this.invoke(Void.class, args);
    }

    Object invoke(Method invokingMethod, Class<?>[] paramTypes, Class<?> returnType, Object[] inArgs, Map<String, ?> options) {
        Object[] args = new Object[]{};
        if (inArgs != null) {
            if (inArgs.length > 256) {
                throw new UnsupportedOperationException(ConfigChangedHandler.l(Union$CallbackResultContext.U("\u8e01\uf37a\u64ee\u04b3\u0dc3\ud85f\u8dca\uadae\ua4b2\ud6ec\ub7c3\u1c05\ua640\uab20\ue17b\u30ad\u3f64\u640f\ud882\u2faa\u6ee3\u1f3d\u36a8\ufb13\u0c75\ufbe1\uf26b\uf862\u4d84")));
            }
            args = new Object[inArgs.length];
            System.arraycopy(inArgs, 0, args, 0, args.length);
        }
        TypeMapper mapper = (TypeMapper)options.get(Union$CallbackResultContext.U("\u8e3a\uf30c\u64e4\u04d1\u0d81\ud829\u8dc4\uad90\ua4a1\ud695\ub7d4"));
        boolean allowObjects = Boolean.TRUE.equals(options.get(Union$CallbackResultContext.U("\u8e2f\uf319\u64f8\u04db\u0ddb\ud869\u8dca\uad82\ua4bb\ud695\ub7c5\u1c6a\ua65c")));
        boolean isVarArgs = args.length > 0 && invokingMethod != null ? Function.isVarArgs(invokingMethod) : false;
        int fixedArgs = args.length > 0 && invokingMethod != null ? Function.fixedArgs(invokingMethod) : 0;
        for (int i = 0; i < args.length; ++i) {
            Class<?> paramType = invokingMethod != null ? (isVarArgs && i >= paramTypes.length - 1 ? paramTypes[paramTypes.length - 1].getComponentType() : paramTypes[i]) : null;
            args[i] = this.convertArgument(args, i, invokingMethod, mapper, allowObjects, paramType);
        }
        Class<?> nativeReturnType = returnType;
        FromNativeConverter resultConverter = null;
        if (NativeMapped.class.isAssignableFrom(returnType)) {
            NativeMappedConverter tc = NativeMappedConverter.getInstance(returnType);
            resultConverter = tc;
            nativeReturnType = tc.nativeType();
        } else if (mapper != null && (resultConverter = mapper.getFromNativeConverter(returnType)) != null) {
            nativeReturnType = resultConverter.nativeType();
        }
        Object result = this.invoke(args, nativeReturnType, allowObjects, fixedArgs);
        if (resultConverter != null) {
            FunctionResultContext context = invokingMethod != null ? new MethodResultContext(returnType, this, inArgs, invokingMethod) : new FunctionResultContext(returnType, this, inArgs);
            result = resultConverter.fromNative(result, context);
        }
        if (inArgs != null) {
            for (int i = 0; i < inArgs.length; ++i) {
                Object inArg = inArgs[i];
                if (inArg == null) continue;
                if (inArg instanceof Structure) {
                    if (inArg instanceof Structure.ByValue) continue;
                    ((Structure)inArg).autoRead();
                    continue;
                }
                if (args[i] instanceof PostCallRead) {
                    ((PostCallRead)args[i]).read();
                    if (!(args[i] instanceof PointerArray)) continue;
                    PointerArray array = (PointerArray)args[i];
                    if (!Structure.ByReference[].class.isAssignableFrom(inArg.getClass())) continue;
                    Class<?> type = inArg.getClass().getComponentType();
                    Structure[] ss = (Structure[])inArg;
                    for (int si = 0; si < ss.length; ++si) {
                        Pointer p = array.getPointer(Native.POINTER_SIZE * si);
                        ss[si] = Structure.updateStructureByReference(type, ss[si], p);
                    }
                    continue;
                }
                if (!Structure[].class.isAssignableFrom(inArg.getClass())) continue;
                Structure.autoRead((Structure[])inArg);
            }
        }
        return result;
    }

    Function(NativeLibrary library, String functionName, int callFlags, String encoding) {
        this.checkCallingConvention(callFlags & 0x3F);
        if (functionName == null) {
            throw new NullPointerException(MCDARichHelper.l(StructureWriteContext$MethodResultContext.u("\u1598\ueed6\u57b4\uc4bf\udc08\ua21d\udf0f\u9dc2\u2d2c\ua7c9\u925a\u16f7\u99d8\u963d\ue859\u2bb2\ua4de\ub021\u903c\uffcc\uaefc\udb8e\u2837\u4d0c\u7033\u9917\u1222\uecfe\u2da1\u5540")));
        }
        this.library = library;
        this.functionName = functionName;
        this.callFlags = callFlags;
        this.options = library.options;
        this.encoding = encoding != null ? encoding : Native.getDefaultStringEncoding();
        try {
            this.peer = library.getSymbolAddress(functionName);
        }
        catch (UnsatisfiedLinkError e) {
            throw new UnsatisfiedLinkError(ConfigChangedHandler.l(StructureWriteContext$MethodResultContext.u("\u1583\ueed6\u57b0\uc4b4\udc16\ua253\udf14\u9dc4\u2d7b\ua7cb\u924a\u16f3\u99c2\u963a\ue859\u2bb0\ua495\ub034\u9071\uffcb\uaee8\udb89\u2866\u4d06\u7020\u9910\u1273")) + functionName + MCDARichHelper.l(StructureWriteContext$MethodResultContext.u("\u158a\ueeea\u5789")) + e.getMessage());
        }
    }

    @Override
    public int hashCode() {
        return this.callFlags + this.options.hashCode() + super.hashCode();
    }

    private static class PointerArray
    extends Memory
    implements PostCallRead {
        private final Pointer[] original;

        public PointerArray(Pointer[] arg) {
            super(Native.POINTER_SIZE * (arg.length + 1));
            this.original = arg;
            for (int i = 0; i < arg.length; ++i) {
                this.setPointer(i * Native.POINTER_SIZE, arg[i]);
            }
            this.setPointer(Native.POINTER_SIZE * arg.length, null);
        }

        @Override
        public void read() {
            this.read(0L, this.original, 0, this.original.length);
        }
    }

    private static class NativeMappedArray
    extends Memory
    implements PostCallRead {
        private final NativeMapped[] original;

        public NativeMappedArray(NativeMapped[] arg) {
            super(Native.getNativeSize(arg.getClass(), arg));
            this.original = arg;
            this.setValue(0L, this.original, this.original.getClass());
        }

        @Override
        public void read() {
            this.getValue(0L, this.original.getClass(), this.original);
        }
    }

    public static interface PostCallRead {
        public void read();
    }
}

